<?php

namespace ADP\BaseVersion\Includes\Rule\Conditions;

use ADP\BaseVersion\Includes\Cart\CartCustomerHelper;
use ADP\BaseVersion\Includes\Cart\Structures\Cart;
use ADP\BaseVersion\Includes\Rule\ConditionsLoader;
use ADP\BaseVersion\Includes\Rule\Interfaces\Conditions\BinaryCondition;

if ( ! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class CustomerLogged extends AbstractCondition implements BinaryCondition
{
    const BIN_YES = 'yes';
    const BIN_NO = 'no';

    const AVAILABLE_COMP_METHODS = array(
        self::BIN_YES,
        self::BIN_NO,
    );

    /**
     * @var bool|null
     */
    protected $comparisonValue;

    public function check($cart)
    {
        $context            = $cart->getContext()->getGlobalContext();
        $cartCustomerHelper = new CartCustomerHelper($context, $cart->getContext()->getCustomer());
        $comparisonValue    = $this->comparisonValue;

        return $cartCustomerHelper->isLoggedIn() === $comparisonValue;
    }

    public static function getType()
    {
        return 'customer_logged';
    }

    public static function getLabel()
    {
        return __('Is logged in', 'advanced-dynamic-pricing-for-woocommerce');
    }

    public static function getTemplatePath()
    {
        return WC_ADP_PLUGIN_VIEWS_PATH . 'conditions/customer/is-logged-in.php';
    }

    public static function getGroup()
    {
        return ConditionsLoader::GROUP_CUSTOMER;
    }

    /**
     * @param string|bool $comparisonValue
     */
    public function setComparisonBinValue($comparisonValue)
    {
        if (in_array($comparisonValue, self::AVAILABLE_COMP_METHODS)) {
            $this->comparisonValue = 'yes' === $comparisonValue;
        } elseif ($comparisonValue === true) {
            $this->comparisonValue = true;
        } else {
            $this->comparisonValue = null;
        }
    }

    public function getComparisonBinValue()
    {
        return $this->comparisonValue;
    }

    /**
     * @return bool
     */
    public function isValid()
    {
        return ! is_null($this->comparisonValue);
    }
}
